# ChatBar #

This is a simple app that makes ChatGPT live in your menubar.

## Store Description
A macOS native menu bar application for completing ChatGPT AI searches with ease. Get the answers you want with adjustable window sizing and keyboard shortcuts for reloading, opening in browser, and more. 

A simple native (non-electron) app to put ChatGPT live in your menubar.

## Website Description
ChatBar adds a ChatGPT web view to your Mac menu bar and a Spotlight style search popup (with api key) for quick chats. You can customize its window height, width, and font size. It incorporates a full suite of keyboard shortcuts to adjust sizing options and additionally Find on page for searching longer chats.

## Trial/Upgrade Version
How to setup, distribute, and update trial versions of the application.
- `#TRIAL: ` build flag in Xcode
- `chatbar-upgrade-trial.json`: File in blog project **blog/Resources/ChatBar** used to contain url, button title and tooltip for application when new versions are available. This will be queried each time the Trial application is launched and displayed to the user with the given title and message. 
    - NOTE: `null` url values will hide button in the UI. 

<br/>
### Features Wish List ###
* [] Auto-Start/Launch At Login. System Helper
* [] Keyboard Shortcuts overlay when pressing and holding cmd *(⌘ ...3-sec)*
* [] MARKDOWN: Allow find on MarkdownUIView
* [x] SIDEBAR: "⌘`" to reset to single window. 
* [] 
* 


### Bugs ###
* [] Enter creates new line instead of sending input. 
      - (WKWebView related)[https://stackoverflow.com/questions/4825295/onclick-to-get-the-id-of-the-clicked-button] 
      - (Possible solution)[https://www.appsloveworld.com/coding/ios/94/keyboard-done-button-pressed-event-for-uiwebview-and-wkwebview]
* [] StickyMode cause popUpMenu hide/show behavior change (Requires custom popover.behavior).
* [] MENU: "Preferences..." shortcut does not toggle the menu as expected when pressed and isVisible.
* [] SEARCHBAR: "Reset Key" button visible when isMissingApiKey. Update "Reset Key" to also reset easteregg counter to 0.
* [x] SEARCHBAR: selecting results triggers reload.
* [] WEBVIEW: No Internet leaves user with Blank page. 
        - Add System Background Color
        - Add no Internet Message
        - Add Reload/Retry message
        - Update Reload(s) to reloadOrigin when web page failed loading.
* [] WEBVIEW: Memory usage higher when not using EasterEgg mode.
* [] URLs: Text area click-to-edit is too narrow. (should be expanded to fill the HStack)
* [x] TOOLBAR: *Open in Browser* tooltip incorrect (`⌘S` vs `⌘O`)
* [x] SIDEBAR: Updating size does not adjust the position of sidebar items.
* [x] Keyboard Shortcuts: add numpad (-, +) to zoom options.
* [x] SIDEBAR: Make sizing percent based for both FS vs NonFS modes.
* [] ADVANCED-IMPORT: visible settings do now update. Reset the screen!
* [] TRIAL: Launch message is missing.
* [] ADVANCED: FS check boxes are not linked to settings initial state.
* [] 
* [] SIDEBAR:  Updating size does not adjust the position of sidebar items.
* [] MAIN: Popup window fails to open on initial launch of app. Requiring user to open Appearance and select a view (shortcuts, release notes) for main window to function correctly.
* [x] ADVANCES: Initial setting for (⌘ + esc) is always unchecked.
* [x] SEARCHBAR: URL returns error.
* [x] MARKDOWN: Changing preview resets the text to default value.
* [x] MARKDOWN: Changing view modes clears markdown saves.
* [x] MARKDOWN: Using URL syntax shortcuts (bold, url, etc) always clears entire clipboard.
* [x] MARKDOWN: Switching form Markdown window does not work correctly until done twice.
* [] 
* [] 
* 
* 


### Improvements ###
* [] MENU: Remove "Preferences..." option from menu but keep cmd + , command to toggle the view.
* [] APPEARANCE: Add pre-macOS 12 option for preview.
* [] MENU: Add "Help" or "Ask a Question" similar to "Duet Display"
* [] VERSION: Lower supported devices to macOS 10.14.11 for older devices.
* [] RELEASE NOTES: Update to show "Whats New" with an option for the full notes. 
* [] WEBVIEW: Url bar slide-in (from top) customization via keyboard shortcut
* [] WEBVIEW: Switching to WebView detects url change and auto reloads or prompt user to reload.
* [] PREFERENCES: Add section for cmd + F customization. (cmd + F vs CMD + shft + F).
* [] PREFERENCES: Add full preferences page.
* [] PREFERENCES: Add single view that combines Appearance, Hotkeys, Urls, and ApiKey settings. 
* [] EXPERIMENTAL: Add section for Printing.
* ~~[] EXPERIMENTAL: Add section for Find/Search~~
* ~~[] EXPERIMENTAL: Add section for Scroll Shortcuts PGUP/PGDWN~~
* ~~[] EXPERIMENTAL: Enter to submit~~
* [] SEARCHBAR: Update search bar to display ApiKey when "Reset Key" button is visible.
* [] SEARCHBAR: Alert user to how to reset ApiKey later (via SearchBar, or EditUrls). 
* [] SEARCHBAR: Copied alert/indication when user clicks copy in results.
* [x] SEARCHBAR: Markdown support for copied text.
* [] SEARCHBAR: Add clear input "x" one input has started. OR clear text on first esc press.
* [] DISPLAY(S): Multiple display support. (User can set sizing for individual displays)
* [] PRINT/SAVE: Use user ApiKey to query entire transcript for printing/saving to pdf or markdown.
* [] WEBFIND: UI put box around all results.
* [] WEBFIND: UI Put yellow highlight on current result.
* [] WEBFIND: Add current URL to bar.(Large view widths show full url, small width show copy button and url on hover).
* [] Shortcuts: SideBar should not show in basic mode.
* [] App: Update app icon to have rounded corners.
* [] SETTINGS: set if esc always hides FindBar
* [] SETTINGS: Set default position for Markdown Preview window. (vertical, horizontal, hidden). Use a mock view with default text similar to font size.
* [] SETTING: set default open state after certain time has elapsed (main view and sideBar view(s))
* [] WEBVIEW: A button to clear page cache.
* [] SETTINGS: Restore SideBar state when relaunching app.
* [] SETTINGS: Restore FindBar state when relaunching app.
* [] TOOLBAR: Convert to use Apple System toolbar.
* [] EXPORT: Update settings json to be more human readable with property items and sections. (e.g. urls, sidebarGroups)
* [] EXPORT: Update settings json to have build version (helps with future json changes if necessary). 
* [] MEMORY: Button to clear cache.
* [] SIDEBAR-GROUP: Add delete button  to clear the saved values.
* [] EASTEREGGS: Add isHemingway enabled to SharedState for app wide responsiveness on change.
* [] IMPORT/EXPORT: Add global shortcuts.
* [x] SEARCHBAR: Button to show recent searches and show results.;
* [x] SEARCHBAR: Update copy button to prepend '## [searchText]\n' when user clicks 'Copy" button.
* [] SEARCHBAR: Add "Continue Chat" button next to copy button that auto copies the text and pastes the current searchBar chat into the view.
* [x] TRIAL: Update to check for its own **isHemingwayEnabled**
* [] MENU-BAR: Add Optional center color to icon in menuBar.
* [x] WEBVIEW: Allow native file picker use (i.e. for chatGPT uploads)
* [x] WEBVIEW: Allow popup (i.e. for file uploads)
* [x] APPERANCE: Fix spacing the pushes bottom row off screen
* ~~[] SIDEBAR: Update width to always use 1/3.~~
* [] SETTING-ADVANCED: Allow setting for `.preferredContentMode` setting.
* [] SETTING-ADVANCED: Allow for FS height override (e.g. still show dock).
* [] MARKDOWN: Allow adjustable size popOut window. (e.g appearance)
* [] MARKDOWN: Allow fixed size floating IN APP window. (e.g PiP)
* [x] WEBVIEW: Allow popup (i.e. for file uploads)
* [x] WEBVIEW: Allow video PiP (i.e. Jira)
* [x] WEBVIEW: Allow file downloads.
* [] SETTING-ADVANCED: Allow escape to exit FS mode and return to regular view mode. (Note 2 esc key presses will be needed to dismiss chatbar from FS mode.).
* [] UPGRADE: Move upgrade warning to a banner. 
* [] UPGRADE: Add check for upgrade/update option to menu.
* [] UPGRADE: Add learnMore/release notes json and button.
* [] UPGRADE: Add check interval 1wk, 1month for update checks.
* [] BUG-REPORT: Menu option to report a bug using the drop down menu.
* [] SEARCHBAR: Add conversation mode to popup which would return the previous conversations.

### Stretch Goals ###
* [] APPEARANCE...: EXPERIMENTAL:  User facing option to hide Header/Footer 
* [] Standalone app window with Tabbed interface option
* [] iPad/iPhone app versions
* [] Option for changing global shortcut to not close when sticky is on. User would use esc only. (Maybe Impossible if controlled by system) 
* []
* [] APPEARANCE...: Custom menu bar icon (color or gray)
* [] Integrate other AI Chats
* [] Hide Header&Footer of webView (1st Attempts FAILED: WKWebView related)
* [] Integrate ChatGPT status into app via popup, hotkey, WebSocket, and/or timer checks.
      - (status page)[https://status.openai.com/]
* [] ADMIN: Option to clear wkWebView cache. 
* [] ADMIN: 
* [] Allow FS SideBar width setting (draggable border?)
* [] HELP: EasterEggs help window.
* [] HELP: Trial help window.
* [] HELP: AppStore help window.
* []  
* []
*

### TechDebt ###
* [] Extensions: move `Date` and `Bundle` extension to separate files.
* [] Wallpaper: Remove failed attempts from wallpaper.
* [] toolbar: Remove failed SwiftUI attempt.
* [] SHORTCUTS: Refactor this view to have more easily setup grids.
* [] FAQ: Why 
* [] FAQ: Launch at Login???
* [] FAQ: Enter to submit???
* [] FAQ: Why is ChatBar slightly off screen sometimes. (ans. window sometimes gets pushed when menubar items move. Recommend placing to the far right.)
* [] FAQ: How do I enable the Spotlight like search bar. (ans. Set the keyboard shortcut and set an api key)
* [] FAQ: Why doesnt reload work on main and SideBar views. (ans. Its complicated. To reload sideBar views right-click and select reload.)
* [] FAQ: 
* [] FAQ: 
* [] FAQ: 
* [] RELEASE NOTES: Update webView to use markdown.
* [] 
* [] 
* [] 
*

### Other ChatGPT Apps ###

* (macGPT)[https://app.gumroad.com/d/63cd9cb9776e8c3422d2e36230778ae8]
    * Pretty good native app. Does not have a right-click
* (ChatGPT-Mac)[https://github.com/vincelwt/chatgpt-mac]
* 
*


<br/>
<br/>
<br/>
---
<br/>


# Completed Items:
This section seeks to clean up the above lists by containg the completed items below for future reference.


### Features Wish List ###
* [x] Global keyboard shortcut
* [x] Right-click menu options
* [x] esc dismisses window
* [x] Keyboard shortcuts for preferences, reload, open-in-browser, and quit, 
* [x] Start/Launch At Login. MenuItem
* [x] APPEARANCE: Adjustable font size options.
* [x] "Menu is sticky" Keep the menu open
* [x] Settings for sticky&login persist (UserDefaults)
* ~~[~] --WONT-DO--Sticky popup outline~~
* [x] Customize global hotkey
* [x] APPEARANCE: Custom Width setting like **macGPT** (small, medium, wide)
* [x] APPEARANCE...: Custom Height setting  (short, medium, tall)
* [x] APPEARANCE...: Live Simulation in “Appearance” View that show what the width and height settings will shops as on the users screen. 
* [x] ABOUT: About Screen (version details and icon)
* [x] Keyboard Shortcuts Sticky hotkey
* [x] Keyboard Shortcuts to adjust font size (-, +)
* [X] Keyboard Shortcuts to adjust window size (↑ , ↓) (← , →)
* [x] Keyboard Shortcuts to toggle FullScreen mode (⌘, F)
* [x] Switch cmd + a to cmd + shft + a
* [x] Add FullScreen size Options (John Mode)
* [x] Floating palette (e.g. Spotlight) that allows for quick questions
* [x] Alternate ChatBot intzergraltion (e.g. Bard.Google)
* [x] WINDOW - UI AWESOME: Allow for custom configuration/window layouts/groups that the user can switch between using keyboard commands with numbers (e.g. ⌘1).


### Bugs ###
* [x] Menu View pop in off screen on first launch
* [x] Reload shortcut does not work on webView (only dropdown)
* [X] App Icon not displayed in About or Appearance
* [x] Menu Shortcuts have shift in them
* [x] About & Appearance windows are Modal. (FIXED: Still Modal just dismiss on escape key)
* [x] APPEARANCE: Esc does not dismiss the view.
* [x] Using Global Hotkey causes cmd shortcuts to be active.
* ~~[~] Refactor Keyboard shortcuts to enable user selection of window resize option from choice of...~~
        - ~~cmd + arrows~~
        - ~~cmd + ctrl + arrows~~
        - ~~cmd + numbers~~
* [x] APPEARANCE: Layout is squashed and partially cut off on bottom of screen on laptop. 
* [x] SEARCHBAR: Update button for to have padding on leading and trailing.
* [x] SHORTCUTS: No way outside of Onboarding/EditUrls to edit global hotkeys. :-(
* [x] SIDEBAR: Zoom/Font size changes do not update side webView.
* [x] SIDEBAR: Update to allow for Jira in side options (⌃⌘J).
* [x] SIDEBAR: Update to allow for Hemingway in side options (⌃⌘H).
* [x] WEBVIEW: Shortcuts dont work on initial load/launch of app.
* [x] ABOUT & APPEARANCE: Blocks all main application interaction when visible.
* [x] "Done": Button (on PopUp) tap area is not the full width. (see onboarding button implementation.) 
* [x] SIDEBAR-GROUP: Switching to group can causes GhatGPT window to be main on subsequest changes.
* [x] SIDEBAR-GROUP: Sometimes switching to a group fails for main view if it was previously selected.
* [x] EDITURLS: Done button not fill bottom row.
* [x] EDITURLS: Editing not functioning correctly.


### Improvements ###
* [x] MENU: Add Version info. similar to "Duet Display"
* [x] EASTER EGG: Customizable url(s) for jira, and gitLab
* [x] WEBFIND: Edit url in the find bar for a given webpage.
* [x] WEBVIEW: A button to reset page.
* [x] WEBVIEW: A button to return home.
* [x] TOOLBAR; Add *App Review* Toolbar for quit access. 😩 (Show/Hide state restored after re-launching the app.)
* [x] DATA: Export/Import app settings (URLs and SidebarGroups)
* [x] SIDEBAR-GROUP: Nil groups display ChatBar instead of dashes.

