#!/bin/bash

# Get the current directory name
directory_path="."
directory_name=$(basename "$PWD")
output_file="${directory_name}_merged.txt"

# Create or empty the output file (exclude this file from being processed by find)
> "$output_file"

# Loop through all files in the current directory and its subdirectories, excluding the output file
find "$directory_path" -type f ! -name "$output_file" | while read -r file; do
    echo "===== $(basename "$file") =====" >> "$output_file"
    cat "$file" >> "$output_file"
    echo -e "\n" >> "$output_file"
    echo "Copied contents of '$file'"
done

echo "All files merged into '$output_file'"
